<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

$successMsg = "";
$errorMsg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $motherName = $_POST['mother_name'] ?? '';
    $email = $_POST['email'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $info = $_POST['info'] ?? '';
    $service = $_POST['service'] ?? '';

    $body = "Name: $name\nMother's Name: $motherName\nEmail: $email\nPhone: $phone\nService: $service\nAdditional Info: $info";

    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host       = 'smtp.yourdomain.com'; 
        $mail->SMTPAuth   = true;
        $mail->Username   = 'your_email@yourdomain.com'; 
        $mail->Password   = 'your_email_password';       
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        $mail->setFrom('your_email@yourdomain.com', 'Readsigns Consult');
        $mail->addAddress('your_email@yourdomain.com'); 
        $mail->addReplyTo($email, $name);

        if (isset($_FILES['proof']) && $_FILES['proof']['error'] === UPLOAD_ERR_OK) {
            $mail->addAttachment($_FILES['proof']['tmp_name'], $_FILES['proof']['name']);
        }

        $mail->Subject = "New Consultation Request from $name";
        $mail->Body    = $body;

        $mail->send();
        $successMsg = "Message sent successfully!";
    } catch (Exception $e) {
        $errorMsg = "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
}
?>

<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Readsigns Consult — Spiritual Consultation</title>
<script src="https://cdn.tailwindcss.com"></script>
<link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@500;700&family=Inter:wght@400;600&display=swap" rel="stylesheet">
</head>
<body class="bg-gradient-to-b from-gray-900 via-indigo-950 to-black text-gray-100 font-['Inter'] antialiased scroll-smooth">

<header class="bg-gradient-to-r from-purple-700 via-indigo-700 to-pink-700 p-6 text-center shadow-lg">
  <h1 class="text-4xl font-['Playfair_Display'] font-bold tracking-wide">✨ Readsigns Consult ✨</h1>
  <p class="text-sm text-gray-200/80 mt-1">Spiritual Consultation & Divination Services</p>
</header>

<main class="max-w-5xl mx-auto p-6">
  <section class="text-center py-16">
    <h2 class="text-5xl font-['Playfair_Display'] font-extrabold leading-tight bg-gradient-to-r from-pink-400 to-purple-400 bg-clip-text text-transparent">Welcome to Readsigns Consult</h2>
    <p class="mt-6 text-gray-300 max-w-3xl mx-auto">At Readsigns Consult, we offer personalized spiritual consultation services designed to help you find clarity and purpose. Explore our trusted divination methods, from card reading and Ifa oracle guidance to palm reading and ancestral sessions (talking to the dead). Discover answers, healing, and spiritual guidance that illuminate your journey.</p>
    <div class="mt-8 flex justify-center gap-4">
      <a href="#consult" class="px-8 py-4 bg-gradient-to-r from-pink-500 to-indigo-600 rounded-xl text-white font-semibold shadow-lg">Book a Consultation</a>
      <a href="#contact" class="px-8 py-4 bg-gradient-to-r from-indigo-500 to-purple-600 rounded-xl text-white font-semibold shadow-lg">Contact Us</a>
    </div>
  </section>

  <section id="consult" class="py-16">
    <h3 class="text-4xl font-['Playfair_Display'] font-bold text-center mb-8">Consultation Request</h3>

    <?php if($successMsg): ?>
      <p class="text-green-400 text-center mb-6 font-semibold"><?= $successMsg ?></p>
    <?php elseif($errorMsg): ?>
      <p class="text-red-400 text-center mb-6 font-semibold"><?= $errorMsg ?></p>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data" class="bg-white/10 backdrop-blur-xl p-8 rounded-2xl grid gap-5 max-w-2xl mx-auto shadow-xl border border-white/10">
      <input name="name" placeholder="Full name" required class="rounded-lg bg-gray-800/70 border border-gray-700 p-3" />
      <input name="mother_name" placeholder="Mother's name" required class="rounded-lg bg-gray-800/70 border border-gray-700 p-3" />
      <input name="email" placeholder="Email address" type="email" required class="rounded-lg bg-gray-800/70 border border-gray-700 p-3" />
      <input name="phone" placeholder="Phone number" type="tel" required class="rounded-lg bg-gray-800/70 border border-gray-700 p-3" />
      <textarea name="info" placeholder="Additional information" rows="4" class="rounded-lg bg-gray-800/70 border border-gray-700 p-3"></textarea>
      
      <select id="service" name="service" required class="rounded-lg bg-gray-800/70 border border-gray-700 p-3">
        <option value="">Select a service</option>
        <option value="card">Card reading — $150</option>
        <option value="ifa">Ifa oracle service — $100</option>
        <option value="palm">Palm reading — $200</option>
        <option value="ancestral">Ancestral session / Talk to the Dead — $2000</option>
        <option value="other">Other — Ask us</option>
      </select>
      <p id="serviceDesc" class="text-gray-300 mt-2 text-sm"></p>

      <div class="bg-gray-800/70 p-5 rounded-lg border border-gray-700">
        <p class="text-sm text-gray-300 mb-3">Upload Gift Card proof</p>
        <input name="proof" type="file" class="text-sm" />
      </div>

      <div id="payment" class="bg-gray-800/70 p-5 rounded-lg border border-gray-700 text-center">
        <h4 class="font-semibold mb-3">Payment — USDT (Ethereum)</h4>
        <div class="flex flex-col items-center gap-4 justify-center">
          <img src="usdt-qr.png" alt="USDT QR" class="w-60 h-60 object-contain bg-white rounded-md p-2 shadow-md mx-auto" />
          <p class="text-sm text-gray-300">Send USDT (ERC-20) to this address:</p>
          <div class="flex items-center gap-3 justify-center">
            <code id="usdtAddress" class="text-2xl font-bold text-pink-400 break-all">0xf762fb87A265D5f84524669E6F73e9918c178FF7</code>
            <button type="button" id="copyBtn" class="px-3 py-1 bg-pink-600 hover:bg-pink-700 rounded text-white text-xs font-semibold">Copy</button>
          </div>
          <p id="copyMsg" class="text-sm text-green-400 mt-2 hidden">Address copied to clipboard ✅</p>
        </div>
      </div>

      <button type="submit" class="px-6 py-3 bg-gradient-to-r from-pink-500 to-indigo-600 rounded-lg font-semibold shadow-lg">Submit Request</button>
    </form>
  </section>

  <section id="contact" class="py-16 text-center">
    <h3 class="text-4xl font-['Playfair_Display'] font-bold mb-6">Contact Us</h3>
    <p class="text-gray-300 mb-8">We’re available for guidance and inquiries through the following platforms:</p>
    <div class="flex justify-center gap-6">
      <a href="https://t.me/yourtelegram" target="_blank" class="px-6 py-3 bg-gradient-to-r from-blue-500 to-blue-700 rounded-lg font-semibold shadow-lg">Telegram</a>
      <a href="https://wa.me/yourwhatsappnumber" target="_blank" class="px-6 py-3 bg-gradient-to-r from-green-500 to-green-700 rounded-lg font-semibold shadow-lg">WhatsApp</a>
      <a href="https://facebook.com/yourfacebookpage" target="_blank" class="px-6 py-3 bg-gradient-to-r from-indigo-500 to-indigo-700 rounded-lg font-semibold shadow-lg">Facebook</a>
    </div>
  </section>
</main>

<footer class="mt-20 py-10 border-t border-gray-800 text-center text-gray-400 text-sm">
  © 2025 Readsigns Consult — All Rights Reserved.
</footer>

<script>
// Copy USDT Address
document.getElementById('copyBtn').addEventListener('click', async () => {
  const addr = document.getElementById('usdtAddress').textContent.trim();
  try {
    await navigator.clipboard.writeText(addr);
    const msg = document.getElementById('copyMsg');
    msg.classList.remove('hidden');
    setTimeout(()=> msg.classList.add('hidden'), 3000);
  } catch (e) {
    alert('Unable to copy address. Please copy manually: ' + addr);
  }
});

// Service description
const serviceDescriptions = {
  card: "Discover insights into your life, relationships, and future through personalized card readings. Each session provides clarity and guidance tailored to your current circumstances.",
  ifa: "Connect with the ancient wisdom of the Ifa oracle to gain spiritual guidance and foresight. This service provides advice on personal, family, and professional matters, aligning you with your destiny.",
  palm: "Understand your personality, strengths, and life path through the art of palmistry. Each reading interprets the lines and features of your hands, offering profound insights into your past, present, and future.",
  ancestral: "Communicate with your ancestors to receive guidance, healing, and protection. This powerful spiritual session helps you connect with your lineage, resolve unresolved issues, and gain clarity on life challenges.",
  other: "Have a unique spiritual concern or inquiry? Reach out to us for a customized consultation tailored specifically to your needs."
};

document.getElementById('service').addEventListener('change', function() {
  const selected = this.value;
  document.getElementById('serviceDesc').textContent = serviceDescriptions[selected] || "";
});
</script>

</body>
</html>
